
(* 1 flyway 1 xbot (actual physical) - autoloading delete,create,activate,holdforzoneready,unload *)
FUNCTION_BLOCK Example24a_autoloading_sending
	(*delete any existing zone*)
	PMC_AutoLoadingZone_Delete1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := Execute,ZoneID := 0);

	(*move xbot to starting positions*)
	xbotID_array78[0] := 1;
	posx_array78[0] := 0.06;
	posy_array78[0] := 0.06;
	PMC_AutoDrivingMotion1(PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZone_Delete1.Done,nXbots := 1,RoutingType := 0,ZoneID := 0,XbotID := xbotID_array78,PosX := posx_array78,PosY := posy_array78);

	(*create an autoloading unloading zone on the top left edge (75,240) of the flyway *)
	PMC_AutoLoadingZone_Create1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_AutoDrivingMotion1.Done,ZoneID := 1,ZoneMode := 0,UnloadingMode := 0,ZoneCenterX := 0.075,ZoneCenterY := 0.24,ZoneLength := 0.12,ZoneWidth := 0.15,MaxXbotSizeX := 0.12,MaxXbotSizeY := 0.12,MaxVel := 1,MaxAcc := 10,MaxHeight := 0);
					
	(*activate the unloading zone*)
	PMC_AutoLoadingZone_Activate1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZone_Create1.Done,ZoneID := 1);

	(*hold until the unloading zone is ready to receive a new xbot*)
	PMC_AutoLoadingZon_HolZoneReady1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZone_Activate1.Done,ZoneID := 1);

	(*move the xbot into the unloading zone*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZon_HolZoneReady1.Done,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := PMC_AutoLoadingZon_HolZoneReady1.ZoneX,PosY := PMC_AutoLoadingZon_HolZoneReady1.ZoneY,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*unload the xbot*)
	PMC_AutoLoadingZone_UnloadXbot1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,ZoneID := 1,XbotID := 1);

	Done := PMC_AutoLoadingZone_UnloadXbot1.Done;
END_FUNCTION_BLOCK
